<?php
/**
 * Elementor Widget
 * @package Panthar
 * @since 1.0.0
 */

namespace Elementor;
class Panthar_Gallery_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'panthar-gallery-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Gallery', 'panthar-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-gallery-grid';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['panthar_widgets'];
    }

    public function get_keywords()
    {
        return ['gallery', 'Sponsor', 'Gallery', "ThemeIM", 'Panthar'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Gallery Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'panthar-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many post you want in masonry , enter -1 for unlimited post.')
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'panthar-core'),
                'DESC' => esc_html__('Descending', 'panthar-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'panthar-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'panthar-core'),
                'title' => esc_html__('Title', 'panthar-core'),
                'date' => esc_html__('Date', 'panthar-core'),
                'rand' => esc_html__('Random', 'panthar-core'),
                'comment_count' => esc_html__('Most Comments', 'panthar-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'panthar-core')
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display(); 
        $all_gallery_items = $settings['gallery_items'];

        //query settings
        $total_posts = $settings['total'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];

        //setup query
        $args = array(
            'post_type' => 'gallery',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'taxonomy' => 'gallery-cat',
            'post_status' => 'publish'
        );
        global $post;
        $post_data = new \WP_Query($args); 

        ?>
        <div class="gallery-area">
            <div class="container text-center">
                <div class="gallery-menu">
                    <ul>
                        <li class="active" data-filter="<?php echo esc_html('*', 'panthar'); ?>">
                            <span class="tag-wrap">
                                <span class="tag">
                                    <span class="style-animate-dot-wrap">
                                        <span class="style-animate-dot"></span>
                                    </span>
                                    <?php echo esc_html('All', 'panthar'); ?>
                                </span>
                            </span>
                        </li>
                        <?php
                        $all_cats = get_categories($args);
                        foreach ($all_cats as $single_cats): ?>
                            <li data-filter=".<?php echo strtolower($single_cats->name); ?>">
                                <span class="tag-wrap">
                                    <span class="tag">
                                        <span class="style-animate-dot-wrap">
                                            <span class="style-animate-dot"></span>
                                        </span>
                                        <?php echo $single_cats->name; ?>  
                                    </span>
                                </span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
            <div class="gallery-item-wrap">
                <?php 
                    $i = 1;
                    while ($post_data->have_posts()) : $post_data->the_post();

                    //category-post
                    $post_categories = get_the_terms( $post->ID, 'gallery-cat' );
                    if ( ! empty( $post_categories ) && ! is_wp_error( $post_categories ) ) {
                        $currentCategories = wp_list_pluck( $post_categories, 'slug' );
                    } ?>
                    <div class="item gallery-single-item-<?php echo esc_attr($i); ?> <?php echo implode(' ', $currentCategories) ?>">
                        <div class="thumb" style="background-image: url(<?php echo esc_url(get_the_post_thumbnail_url()); ?>);"></div>
                        <a class="popup-btn image-popup-vertical-fit" href="<?php echo esc_url(get_the_post_thumbnail_url()); ?>">
                            <i class="icomoon-plus-sign"></i>
                        </a>
                    </div>
                <?php 
                    $i++;
                    endwhile; 
                ?>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Panthar_Gallery_Widget());
