<?php
/**
 * Theme About Us Widget
 * @package Panthar
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('panthar_about_widget', array(
        'title' => esc_html__('Panthar: About Us', 'panthar-core'),
        'classname' => 'panthar-widget-about',
        'description' => esc_html__('Display about us widget', 'panthar-core'),
        'fields' => array(
            array(
                'id' => 'logo-area',
                'type' => 'media',
                'title' => esc_html__('Upload Your Photo', 'panthar-core'),
            ),
            array(
                'id' => 'description',
                'type' => 'textarea',
                'title' => esc_html__('Description', 'Panthar-core'),
                'default' => esc_html__('Our team includes doormen, bodyguards, and parking lot patrol officers to safe.', 'panthar-core')
            ),
            array(
                'id' => 'address',
                'type' => 'textarea',
                'title' => esc_html__('Address', 'Panthar-core'),
                'default' => esc_html__('Street. 2891, Denpasar, Bali', 'panthar-core')
            ),
            array(
                'id' => 'email',
                'type' => 'text',
                'title' => esc_html__('Email', 'Panthar-core'),
                'default' => esc_html__('info@example.com', 'panthar-core')
            ),
            array(
                'id' => 'panthar-footer-social-icon-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Icon', 'panthar-core'),
                'fields' => array(

                    array(
                        'id' => 'panthar-footer-social-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'panthar-core'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'panthar-footer-social-text',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Url', 'panthar-core'),
                        'default' => esc_html__('#', 'panthar-core')
                    ),

                ),
            ),
        )
    ));


    if (!function_exists('panthar_about_widget')) {
        function panthar_about_widget($args, $instance)
        {

            echo $args['before_widget'];

            // var_dump( $args ); // Widget arguments
            // var_dump( $instance ); // Saved values from database

            $instance['logo-area'];
            $logo = $instance['logo-area'];
            $img_id = $logo['id'] ?? '';
            $img_print = $img_id ? wp_get_attachment_image_src($img_id,'full')[0] : '';
            $alt_text = get_post_meta($img_id, '_wp_attachment_image_alt', true);
            $paragraph = $instance['description'] ?? '';
            $address = $instance['address'] ?? '';
            $email = $instance['email'] ?? '';
            $socialIcon = is_array($instance['panthar-footer-social-icon-repeater']) && !empty($instance['panthar-footer-social-icon-repeater']) ? $instance['panthar-footer-social-icon-repeater'] : [];


            ?>
            <div class="footer-widget widget">
                <div class="about_us_widget style-01">
                    <a href="<?php echo get_home_url(); ?>" class="footer-logo"><?php
                        if (!empty($img_print)) {
                            printf('<img src="%1$s" alt="%2$s"/>', esc_url($img_print), esc_attr($alt_text));
                        }
                        ?></a>
                    <p> <?php echo $paragraph; ?></p>
                    <ul class="address-info mb-3">
                        <li><i class="icomoon-map-marker"></i><?php echo $address; ?></li>
                        <li><a href="mailto:<?php echo $email; ?>"><i class="icomoon-mail"></i><?php echo $email; ?></a></li>
                    </ul>
                    <ul class="contact_info_list">
                        <?php
                        foreach ($socialIcon as $icon) {
                            echo '<li class="single-info-item">
                            <div class="icon"><a href="'.$icon['panthar-footer-social-text'].'">
                                <i class="' . $icon['panthar-footer-social-icon'] . '"></i></a>
                            </div>
                        </li>';
                        };
                        ?>
                    </ul>
                </div>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>